// ==UserScript==
// @name        MusicFond helper for Opera 8 - 9
// @version     1.01
// @date        2007-10-01
// @author      Mike Samokhvalov <mikivanch@gmail.com>
// @download    http://www.puzzleclub.ru/files/musicfond_com.js
// @include     http://musicfond.com/*
// ==/UserScript==

(function(){
  //  !
  var submitValue = '&#1055;&#1086;&#1083;&#1091;&#1095;&#1080;&#1090;&#1100;&#32;&#1089;&#1089;&#1099;&#1083;&#1082;&#1091;&#33;';  
  
  var count = 0;
  var addStyle = function(css)
  {
    if(!document || !document.documentElement)
    {
      if(count < 500)
      {
        setTimeout(addStyle, 25, css);
        count++;
      }
      return;
    }
      
    var s = document.createElement('style');
    s.setAttribute('type', 'text/css');
    s.setAttribute('style', 'display:none !important;');			
    s.appendChild(document.createTextNode(css));
    document.documentElement.appendChild(s); 
  };
  
  window.opera.addEventListener('BeforeExternalScript', function (e) {      
    var src = e.element.getAttribute('src', false);
    if(src.indexOf('http://readme.ru/') != -1)
      e.preventDefault();
    else if(src.indexOf('http://js.redtram.com/') != -1)
      e.preventDefault();
      
    onLoad();  
  }, false);
    
  window.opera.addEventListener('BeforeScript', function(e){
    var t = e.element.text;
    if(t.search(/document\.write\x28(?:\s+)?[\x22\x27]?(?:<table|<iframe|<img|<a|<sc)/i) != -1)  
    {    
      e.preventDefault();
    }
    onLoad();
  }, false);
  
  var onLoad = function()
  {
    var a = document.createElement('a');
    a.innerHTML = submitValue;
    
    var input = document.getElementsByTagName('input');
    for(var i = input.length - 1; i >= 0; i--)
    {
      if(input[i].type == 'submit' && input[i].value == a.innerText)      
      {
        input[i].click();
        break;
      }
    }
  }
  
  var css = 'noindex *, iframe, noscript iframe, div#rtn4pmc_len1, div#rtn4pmc_len2 {display: none !important;}';
  if(typeof(window.opera.version) == 'function' && window.opera.version() >= 9)
  {
   css += ' div[id*="rdminfrm_"] {display: none !important;}';
  }
  addStyle(css);
  
  if(typeof(window.opera.version) == 'function' && window.opera.version() >= 9)
    document.addEventListener('DOMContentLoaded', onLoad, false);  
  else
    document.addEventListener('load', onLoad, false);
  
  /*
  window.opera.addEventListener('BeforeExternalScript', function(e){
    if(e.element.src.indexOf('http://autocontext.begun.ru/') >= 0)
      e.preventDefault();
  } ,false);
  */
})();