// ==UserScript==
// @name        Download video from http://www.tnt-tv.ru/video/
// @version     1.02
// @date        2007-10-09
// @author      Mike Samokhvalov <mikivanch@gmail.com>
// @download    http://www.puzzleclub.ru/files/tnt-tv_ru_video.js
// @include     http://*tnt-tv.ru/*
// ==/UserScript==

(function(){
  var style1 = 'display: block; font-size: 9pt; line-height: 1.4; text-align: center !important; padding: 0 10px;';
  var style2 = 'display: block; border-bottom: 1px solid #d0d0d0; font-size: 9pt; line-height: 1.4; !important; padding-bottom: 10px; margin-bottom: 10px;';
  
  var getVideoName = function(id)
  {
    var n = '';
    var d = document.getElementById('videof');
    if(d)
    {
      var h = d.getElementsByTagName('h1');
      if(h && h.length > 0)
      {
        n = h[0].innerText;
      }
    }
    
    d = document.getElementById('videoofd');
    if(d)
    {
      var h = d.getElementsByTagName('h3');
      if(h && h.length > 0)
      {
        if(n)
          n += ' - ' + h[0].innerText;
        else
          n = h[0].innerText;
      }
    }
    
    if(!n && document.title)
    {
      n = document.title;      
    }
    
    if(n)
    {
      n = n.replace(/[\x2F\x5C\x3A\x7C]/g, '-');
      n = n.replace(/[\x2A\x3F]/g, '');
      n = n.replace(/\x22/g, '\'');
      n = n.replace(/\x3C/g, '(');
      n = n.replace(/\x3E/g, ')');
      n = n.replace(/(?:^\s+)|(?:\s+$)/g, '');
    }
    else
    {
      n = id;
    }
    n += '.flv';

    return n;
  };
  
  var getVideoFile = function(parent)
  {
    var p = parent.getElementsByTagName('param');
    for(var i = 0; i < p.length; i++)
    {
      if(p[i].name.toLowerCase() == 'flashvars')
      {
        if(p[i].value)
        {
          var v = /id=(\w+)/i.exec(p[i].value);
          if(v && v.length > 1)
          {
            return v[1];            
          }
        }
        break;
      }
    }

    return ''; 
  };
  
  var addLink = function(name, parent, style)
  {
    var d = document.createElement('div');
    d.setAttribute('style', style, false);
    d.innerHTML = (
      '<a href="http://www.tnt-tv.ru/Files/VideoFLV/' + name + '" style="font-size: 16pt;">\u0421\u043a\u0430\u0447\u0430\u0442\u044c</a><br>'
      +' ' + getVideoName(name)
    );
    parent.insertBefore(d, parent.firstChild);
  };  
  
  var onLoad = function()
  {
    var d = document.getElementById('videofflash');
    if(d)
    {
      var name = getVideoFile(d);
      if(name)
      {
        addLink(name, d, style1);
        return;
      }
    }
    
    d = document.getElementById('flashvideo');
    if(d)
    {
      var name = getVideoFile(d);
      if(name)
      {
        var parent = document.getElementById('flashvideotxt');
        if(!parent)
        {
          parent = d;
        }
        addLink(name, parent, style2);
        return;
      }
    }
  };
  
  if(typeof(window.opera.version) == 'function' && window.opera.version() >= 9)
    document.addEventListener('DOMContentLoaded', onLoad, false);  
  else
    document.addEventListener('load', onLoad, false);
})();